import { type NextRequest, NextResponse } from "next/server"
import { createRouteHandlerClient } from "@supabase/auth-helpers-nextjs"
import { cookies } from "next/headers"

export async function GET(request: NextRequest, { params }: { params: { slug: string } }) {
  try {
    const supabase = createRouteHandlerClient({ cookies })

    const { data: post, error } = await supabase
      .from("blog_posts")
      .select(`
        *,
        blog_post_categories(
          blog_categories(*)
        ),
        profiles(email)
      `)
      .eq("slug", params.slug)
      .eq("status", "published")
      .single()

    if (error || !post) {
      return NextResponse.json({ error: "Blog post not found" }, { status: 404 })
    }

    return NextResponse.json({ post })
  } catch (error) {
    console.error("Error fetching blog post:", error)
    return NextResponse.json({ error: "Internal server error" }, { status: 500 })
  }
}
